//+------------------------------------------------------------------+
//|                                                  Test_Button.mq5 |
//|                                           Copyright 2015, MigVRN |
//|                                                    Miguzov@bk.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, MigVRN"
#property link      "https://www.mql5.com/ru/users/migvrn"
#property version   "1.00"

#include "BmpButtonTransparent.mqh"
//+------------------------------------------------------------------+
//| Resources                                                        |
//+------------------------------------------------------------------+
#resource "\\Images\\200_1.bmp"
#resource "\\Images\\200_2.bmp"
#resource "\\Images\\200_3.bmp"
#resource "\\Images\\200_4.bmp"

//+------------------------------------------------------------------+
//| Global variables                                                 |
//+------------------------------------------------------------------+
input ENUM_BASE_CORNER Corner  = CORNER_LEFT_UPPER; //Corner
input              int X_first = 10;                //X-coordinate
input              int Y_first = 10;                //Y-coordinate

//+------------------------------------------------------------------+
//| Global variables                                                 |
//+------------------------------------------------------------------+
CBmpButtonTransparent Button[9];
string Off_Passive_name;
string Off_Active_name;
string On_Passive_name;
string On_Active_name;
int Sub_window;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- Get number of the chart subwindow
   Sub_window=ChartWindowOnDropped();

//--- Send notifications of mouse move and mouse click events to all mql5 programs on a chart
   if(!ChartSetInteger(0,CHART_EVENT_MOUSE_MOVE,true))
      return(-1);

//--- Set image for button
   Off_Passive_name= "::Images\\200_1.bmp";
   Off_Active_name = "::Images\\200_2.bmp";
   On_Passive_name= "::Images\\200_3.bmp";
   On_Active_name = "::Images\\200_4.bmp";

//--- Get width and height BMP file
   uint width;
   uint height;
   if(!Button[0].GetWidthAndHeightBmp(Off_Passive_name,width,height))
      return(INIT_FAILED);

//--- Set first coordinates
   int x1 = X_first;
   int x2 = X_first+(int)width;
   int y1 = Y_first;
   int y2 = Y_first+(int)height;

   switch(Corner)
     {
      case CORNER_LEFT_UPPER:
        {
         break;
        }
      case CORNER_LEFT_LOWER:
        {
         y1 += (int)height;
         y2 += (int)height;
         break;
        }
      case CORNER_RIGHT_LOWER:
        {
         x1 += (int)width;
         x2 += (int)width;
         y1 += (int)height;
         y2 += (int)height;
         break;
        }
      case CORNER_RIGHT_UPPER:
        {
         x1 += (int)width;
         x2 += (int)width;
         break;
        }
     }

//---Counter columns   
   int count_columns=0;

//--- Create button
   for(int i=0; i<9; i++)
     {
      //--- Create button  
      if(!Button[i].Create(0,"Button["+(string)i+"]",Sub_window,x1,y1,x2,y2))
         return(INIT_FAILED);

      if(!Button[i].SetCorner(Corner))
         return(INIT_FAILED);

      //---Set next coordinates
      count_columns++;
      if(count_columns>2)
        {
         count_columns=0;
         x1-=2*((int)width-48);
         x2 = X_first+(int)width;
         y1+= (int)height-48;
         y2 = y1+(int)height;
        }
      else
        {
         x1+= (int)width-48;
         x2 = x1+(int)width;
        }

      //--- Set Bmp images for button
      if(!Button[i].BmpOffPassiveName(Off_Passive_name))
         return(INIT_FAILED);
      if(!Button[i].BmpOffActiveName(Off_Active_name))
         return(INIT_FAILED);
      if(!Button[i].BmpOnPassiveName(On_Passive_name))
         return(INIT_FAILED);
      if(!Button[i].BmpOnActiveName(On_Active_name))
         return(INIT_FAILED);

      //--- Set transparent for button
      if(!Button[i].SetTransparent(Off_Passive_name))
         return(INIT_FAILED);

      //---Set width of border button    
      if(!Button[i].Border(0))
         return(INIT_FAILED);

      //---Set type and state button
      Button[i].Locking(true);
      Button[i].Pressed(false);

      //---Refresh bmp afther all settings   
      if(!Button[i].RefreshBmp())
         return(INIT_FAILED);
     }
//--- Succeed    
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//--- Destroy buttons
   for(int i=0; i<9; i++)
     {
      Button[i].Destroy(reason);
     }
   Comment("");
  }
//+------------------------------------------------------------------+
//| Event Click function                                             |
//+------------------------------------------------------------------+
void OnClickButton(int index)
  {
   Button[index].Press();

   if(Button[index].Pressed())
      Comment("Button ",index," - ON");
   else
      Comment("Button ",index," - OFF");
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
//--- Correction coordinates
   double y=dparam;
   y-=(int)ChartGetInteger(0,CHART_WINDOW_YDISTANCE,Sub_window);

   for(int i=0; i<9; i++)
     {
      //--- if event ON_CLICK
      if(id==(ON_CLICK+CHARTEVENT_CUSTOM) && sparam==Button[i].Name())
        {
         OnClickButton(i);
         return;
        }

      //--- if not event
      Button[i].OnEvent(id,lparam,y,sparam);
     }
  }
//+------------------------------------------------------------------+
